# This list represents the core inventory data (an associative list: [ID, Cost])
PRODUCT_COST_LIST = [
    ['A4_P01', 5.00],
    ['NBOOK_S', 4.50],
    ['HBOOK_C', 12.75],
    ['PENCIL_P', 3.25]
]

# A separate list detailing the current stock quantities
STOCK_QUANTITIES = {
    'A4_P01': 100,
    'NBOOK_S': 50,
    'HBOOK_C': 20,
    'ERASER': 10
}

# You'll need to write TWO functions to solve this problem!

# Write a function named: convert_to_cost_dictionary
#   The function takes one parameter:
#       The list of lists representing the products and costs (PRODUCT_COST_LIST)
#
#   The function should return a NEW dictionary where all the product names are keys
#       and the costs are their respective values.

# Write your convert_to_cost_dictionary function here...



# Write a function named: calculate_total_inventory_value
#   The function takes two parameters:
#       The first is the dictionary representing all items and their costs
#       The second is the dictionary of inventory quantities
#
#   The function should return the total value of the inventory
#       Note that items without a cost are valued at 0.

# Write your calculate_total_inventory_value function here...


# Tests for your functions
#   You might want to comment out the tests for function 2 until you have finished
#   the first function.
#   NOTE: On the exam, tests will not be provided. You'll need to write your own.

# Function 1 Test: Convert list to dict
product_costs = convert_to_cost_dictionary(PRODUCT_COST_LIST)
print(f"Product Costs Dictionary:\n{product_costs}\n")

# Function 2 Test: Calculate total cost
# Expected Total:
# (100 * 5.00) + (50 * 4.50) + (20 * 12.75) + (10 * 0.00 [ignored])
# 500.00 + 225.00 + 255.00 = 980.00
inventory_value = calculate_total_inventory_value(product_costs, STOCK_QUANTITIES)
print(f"Stock Quantities:\n{STOCK_QUANTITIES}")

# The :.2f displays the number with exactly two decimal places
print(f"\nTotal Inventory Value: ${inventory_value:.2f}")
