# Debugging: Student Grader
#
#   You are about ready to grade your student's assignments,
#   but notice that your program doesn't seem to be working
#   correctly. Grades are due soon and you need to work fast!
#   
#   There are multiple errors in the code below. Some errors
#   are syntactic, meaning that the Python code is not written
#   properly or is "grammatically incorrect" and Python can't
#   understand what you want. These are a bit easier to spot.
# 
#   Other errors are in the logic which is much trickier to find.
#   Logic errors mean the code works, but it doesn't produce the correct
#   result. You will need to pretend you are a detective and each line of
#   the code is a suspect. :)
#
#   Good luck! We're all counting on you!

def calculate_grade(scores):
    print "Starting grade calculation..."
    
    final_score = 0
    
    # Dictionary of assignment weights (percentages)
    weights = {
        'Midterm': 0.30,
        'Final Exam': 0.40,
        'Labs': 0.30
    }
    
    # Loop to calculate the total weighted score
    for assignment, weight in weights:
        score = scores.get(assignment, 0)
        final_score = final_score + weight + score

    if final_score / 100 > 90:
        return 'A'
    elif final_score >= 80:
        return 'B'
    elif final_score >= 70
        return 'C'
    else:
        return 'F'

# Student scores (out of 100 for each category)
student_scores = {
    'Midterm': 85,
    'Final Exam': 95,
    'Labs': 90
}

letter_grade = calculate_grad(student_scores)

print(f"Student Final Score: {letter_grade}")